function adjustWindowSize(defWidth, defHeight) {
   element = document.getElementById("hmcPanelTable");
   desiredWidth = -1; desiredHeight = -1;

   // If the width and height were explicitly given, use those.
   attr = element.attributes.getNamedItem["width"];
   if (attr != null) desiredWidth = attr.value;

   attr = element.attributes.getNamedItem["height"];
   if (attr != null) desiredHeight = attr.value;

   if (desiredWidth == -1 && desiredHeight == -1) {
      // If the window starts narrow, we don't necessarily want it to stay
      // narrow.  Give the window the default size initially and let it go up
      // or down from there.
      window.resizeTo(defWidth, defHeight);
   }

   // If no explicit values, but the browser will tell us the size, use that.
   if (desiredWidth == -1 && "offsetWidth" in element)
      desiredWidth = element.offsetWidth;

   if (desiredHeight == -1 && "offsetHeight" in element)
      desiredHeight = element.offsetHeight;

   // Resize if we know what the desired size is, otherwise leave it alone.
   if (desiredWidth != -1 && desiredHeight != -1) {
      widthPadding = 32; heightPadding = 32;

      if ("innerWidth" in window && "outerWidth" in window)
         widthPadding = window.outerWidth - window.innerWidth;

      if ("innerHeight" in window && "outerHeight" in window)
         heightPadding = window.outerHeight - window.innerHeight;

      finalWidth  = desiredWidth + widthPadding + 24;
      if (finalWidth > screen.availWidth * 95 / 100)
         finalWidth = screen.availWidth * 95 / 100;

      finalHeight = desiredHeight + heightPadding + 24;
      if (finalHeight > screen.availHeight * 95 / 100)
         finalHeight = screen.availHeight * 95 / 100;

      window.resizeTo(finalWidth, finalHeight);

      if ("screenX" in window && "screenY" in window) {
         // Remember the beginning position of the window
         window.savedScreenX = window.screenX;
         window.savedScreenY = window.screenY;
//       alert("Window is presently at "+window.savedScreenX+", "+window.savedScreenY);

         // If we resized the window, the right edge or bottom edge might now
         // be off the screen.  Move left or up to correct that if necessary.
         moveLeft = 0; moveUp  = 0;
         if (window.screenX + finalWidth > screen.availWidth)
            moveLeft = window.screenX + finalWidth - screen.availWidth;

         if (window.screenY + finalHeight > screen.availHeight)
            moveUp = window.screenY + finalHeight - screen.availHeight;

         if (moveLeft != 0 || moveUp != 0) {
            window.moveBy(-moveLeft, -moveUp);
         }
      }
   }
}

function getHMCMainWindow(target) {
   // window.opener refers to the TaskController frame in the main ui window.
   // window.opener.top, therefore, refers to that frameset, which is defined
   // in mainuiFrameset.jsp.
   if ("hmcuimainwin" in target) {
//alert("using hmcuimainwin from window properties");
      return target.hmcuimainwin;

   } else {
      try {
         if (target.opener.top.name == "hmcuimainwin") {
//alert("using opener.top");
            return target.opener.top;

         } else {
//alert("using window.open");
            mw = window.open("", "hmcuimainwin");
            if (mw != null) {
               // See if it's the main window we're expecting.  If it is,
               // it has a function called markWindowCloseHandled().  If our
               // window.open() call just created the window, then it won't.
               if ("markWindowCloseHandled" in mw)
                  return mw;
               mw.close();  // We must have just opened it.  Close it quickly.
               return null;
            }
            return null;
         }

      } catch (e) {
         return null;
      }
   }
}

function callProcessTaskWindowUnload() {
   mw = getHMCMainWindow(window);

   if (mw != null)
      mw.processTaskWindowUnload(window);
}

function initializeWinProps(taskId) {
//window.alert("in initializeWinProps().  Task id is "+taskId);
   window.hmcTaskId = taskId;

   try {
      if (opener.top.name == "hmcuimainwin")
         window.hmcuimainwin = opener.top;
      else
         window.hmcuimainwin = window.open("", "hmcuimainwin");

   } catch (e) {
      // Can't figure out main window
   }
}

function hmcFormSubmitted() {
   if ("screenX" in window && "screenY" in window &&
       "savedScreenX" in window && "savedScreenY" in window) {
      if (window.screenX != window.savedScreenX ||
          window.screenY != window.savedScreenY) {    // Window was moved

         if ("action" in this && this.action.indexOf("/hmc/wcl/") != -1) {
            // Create a hidden form field to transmit the current window position
            // This name/value pair will be included in the form that is submitted.
            hmcScreenElement = document.createElement("input");
            hmcScreenElement.setAttribute("type", "hidden");
            hmcScreenElement.setAttribute("name", "hmcWindowPosition");
            hmcScreenElement.setAttribute("value", ""+window.screenX+","+window.screenY);
            this.appendChild(hmcScreenElement);
         }
      }
   }
}

function trapWindowClose() {
//alert("in trapWindowClose");
   window.onunload = callProcessTaskWindowUnload;

   // Trap any form submissions so that we can communicate any window moves
   for (var i=0; i<document.forms.length; ++i) {
//    alert("Form "+i+": "+(typeof document.forms[i].onsubmit));
      document.forms[i].onsubmit = hmcFormSubmitted;
   }
}
